<?php
/**
 * Plugin Name:           Badamsoft Product Exporter for WooCommerce
 * Description:           Export WooCommerce products to CSV.
 * Version:               1.1.1
 * Requires at least:     6.5
 * Tested up to:          6.9
 * Requires PHP:          7.4
 * Requires Plugins:      woocommerce
 * WC requires at least:  8.0
 * WC tested up to:       10.5.0
 * Author:                BadamSoft LLC
 * Author URI:            https://badamsoft.com
 * License:               GPLv2 or later
 * License URI:           https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:           badamsoft-product-exporter-for-woocommerce
 * Domain Path:           /languages
 */

declare(strict_types=1);

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action(
    'before_woocommerce_init',
    static function (): void {
        if ( class_exists( '\\Automattic\\WooCommerce\\Utilities\\FeaturesUtil' ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
    }
);

if ( ! defined( 'PRODEXFO_VERSION' ) ) {
    define( 'PRODEXFO_VERSION', '1.1.1' );
}

if ( ! defined( 'PRODEXFO_PLUGIN_FILE' ) ) {
    define( 'PRODEXFO_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'BADAPREX_PLUGIN_FILE' ) ) {
    define( 'BADAPREX_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'PRODEXFO_PLUGIN_BASENAME' ) ) {
    define( 'PRODEXFO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
}

add_filter( 'plugin_row_meta', 'prodexfo_plugin_row_meta', 10, 2 );

/**
 * Add plugin meta links.
 *
 * @param array  $links Plugin meta links.
 * @param string $file  Plugin file.
 * @return array
 */
function prodexfo_plugin_row_meta( array $links, string $file ): array {
    if ( PRODEXFO_PLUGIN_BASENAME !== $file ) {
        return $links;
    }

    $links[] = '<a href="https://badamsoft.com/documentation/?doc_product=exporter&cat=exporter-guide" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Documentation', 'badamsoft-product-exporter-for-woocommerce' ) . '</a>';

    $is_pro = function_exists( 'prodexfo_is_pro' ) ? (bool) prodexfo_is_pro() : false;

    if ( ! $is_pro ) {
        $links[] = '<a href="https://badamsoft.com/wooproduct-exporter/" target="_blank" rel="noopener noreferrer" style="color:#2e7d32;font-weight:600;">' . esc_html__( 'PRO add-on', 'badamsoft-product-exporter-for-woocommerce' ) . '</a>';
    }

    return $links;
}

if ( ! defined( 'PRODEXFO_PLUGIN_DIR' ) ) {
    define( 'PRODEXFO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'BADAPREX_PLUGIN_DIR' ) ) {
    define( 'BADAPREX_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'PRODEXFO_PLUGIN_URL' ) ) {
    define( 'PRODEXFO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'BADAPREX_PLUGIN_URL' ) ) {
    define( 'BADAPREX_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

// PSR-4 autoloader for the core plugin classes (BadamSoft\WooProductExporter\*) from src/.
$prodexfo_src_psr4_autoload = PRODEXFO_PLUGIN_DIR . 'src/autoload.php';

if ( file_exists( $prodexfo_src_psr4_autoload ) ) {
    require_once $prodexfo_src_psr4_autoload;
}

// Shared Composer autoloader (plugin core dependencies).
$prodexfo_composer_autoload        = PRODEXFO_PLUGIN_DIR . 'vendor/autoload.php';
$prodexfo_composer_autoload_backup = PRODEXFO_PLUGIN_DIR . '___vendor/autoload.php';

$prodexfo_has_composer_autoload = false;

if ( file_exists( $prodexfo_composer_autoload ) ) {
    require_once $prodexfo_composer_autoload;
    $prodexfo_has_composer_autoload = true;
} elseif ( file_exists( $prodexfo_composer_autoload_backup ) ) {
    require_once $prodexfo_composer_autoload_backup;
    $prodexfo_has_composer_autoload = true;
}

// Pro-mode flag: defaults to Free; Pro add-on can override via filter.
if ( ! function_exists( 'prodexfo_is_pro' ) ) {
    function prodexfo_is_pro(): bool {
        $flag = false;

        return (bool) apply_filters( 'prodexfo_is_pro', $flag );
    }
}

// Load the shared plugin core. Pro add-on can extend functionality independently.
$prodexfo_core_bootstrap = PRODEXFO_PLUGIN_DIR . 'includes/bootstrap.php';

if ( file_exists( $prodexfo_core_bootstrap ) ) {
    require_once $prodexfo_core_bootstrap;
}
