<?php

declare(strict_types=1);

use BadamSoft\WooProductExporter\Core\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( file_exists( dirname( __DIR__ ) . '/src/autoload.php' ) ) {
    require_once dirname( __DIR__ ) . '/src/autoload.php';
}

if ( ! class_exists( 'BadamSoft\\WooProductExporter\\Core\\Plugin' ) ) {
    $prodexfo_src_plugin_file = dirname( __DIR__ ) . '/src/Core/Plugin.php';

    if ( file_exists( $prodexfo_src_plugin_file ) ) {
        require_once $prodexfo_src_plugin_file;
    }
}

// Initialize core on plugins_loaded so the Pro add-on can register filters first (e.g. prodexfo_is_pro).
add_action(
    'plugins_loaded',
    static function (): void {
        Plugin::init( PRODEXFO_PLUGIN_FILE );
        do_action( 'prodexfo_pro_loaded' );
    },
    20
);
