<?php

declare(strict_types=1);

namespace BadamSoft\WooProductExporter\Exporter\Formats\Contracts;

interface WriterInterface {
    /**
     * Prepare writer for streaming.
     *
     * @param array<int, string>                  $fields            Selected field keys.
     * @param array<string, array<string, mixed>> $field_definitions Metadata for each field.
     * @param array<string, mixed>                $settings          Export settings (delimiter, encoding, filename, etc.).
     */
    public function open( array $fields, array $field_definitions, array $settings = [] ): void;

    /**
     * Write a normalized row keyed by field key.
     *
     * @param array<string, mixed> $row
     */
    public function writeRow( array $row ): void;

    /**
     * Finish streaming and flush the response.
     */
    public function close(): void;

    public function getKey(): string;

    public function getLabel(): string;

    public function getFileExtension(): string;

    public function getContentType(): string;
}
