<?php

declare(strict_types=1);

namespace BadamSoft\WooProductExporter\Exporter\Formats;

use BadamSoft\WooProductExporter\Helpers\Logger;

class CsvExporter {
    /**
     * Stream CSV export to the browser.
     *
     * @param array<int, string>                 $fields            Selected field keys.
     * @param array<string, array<string, mixed>> $field_definitions Field metadata map.
     * @param callable                            $rows_callback     Callback that receives the CSV handle.
     */
    public function stream( array $fields, array $field_definitions, callable $rows_callback ): void {
        $filename = sprintf( 'wc-products-export-%s.csv', \wp_date( 'Y-m-d-H-i-s' ) );

        ignore_user_abort( true );
        nocache_headers();

        header( 'Content-Type: text/csv; charset=utf-8' );
        header( 'Content-Disposition: attachment; filename=' . $filename );
        header( 'Pragma: no-cache' );
        header( 'Expires: 0' );

        $output = fopen( 'php://output', 'w' ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fopen

        if ( false === $output ) {
            Logger::error( 'Could not open CSV output stream.' );
            wp_die( esc_html__( 'Could not open output stream.', 'badamsoft-product-exporter-for-woocommerce' ) );
        }

        // Prepend UTF-8 BOM for Excel compatibility.
        fprintf( $output, "\xEF\xBB\xBF" );

        $headers = [];

        foreach ( $fields as $field_key ) {
            $headers[] = $field_definitions[ $field_key ]['label'] ?? $field_key;
        }

        fputcsv( $output, $headers );

        $rows_callback( $output );

        fclose( $output ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fclose
    }
}
