<?php

declare(strict_types=1);

namespace BadamSoft\WooProductExporter\Helpers;

class DownloadHelper {
    public const BOM_UTF8 = "\xEF\xBB\xBF";

    public static function send_headers( string $filename, string $content_type, int $last_modified = 0 ): void {
        ignore_user_abort( true );
        nocache_headers();

        header( 'Content-Type: ' . $content_type );
        header( 'Content-Disposition: attachment; filename=' . $filename );
        header( 'Pragma: no-cache' );
        header( 'Expires: 0' );
        
        if ( $last_modified > 0 ) {
            header( 'Last-Modified: ' . \wp_date( 'D, d M Y H:i:s', $last_modified ) . ' GMT' );
        }
    }

    /**
     * @param resource $handle
     */
    public static function emit_bom( $handle, string $bom = self::BOM_UTF8 ): void {
        fwrite( $handle, $bom ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fwrite
    }
}
