<?php

declare(strict_types=1);

namespace BadamSoft\WooProductExporter\Scheduled;

use BadamSoft\WooProductExporter\Helpers\ChunkQuery;
use BadamSoft\WooProductExporter\Helpers\Logger;

class ChunkProcessor {
    /**
     * Process products in chunks using a callback.
     *
     * @param callable $callback Receives WC_Product.
     * @param array<string, mixed> $query_args Additional query filters.
     */
    public function process( callable $callback, array $query_args = [] ): void {
        ChunkQuery::loop(
            $query_args,
            function ( int $product_id ) use ( $callback ): void {
                $product = wc_get_product( $product_id );

                if ( ! $product ) {
                    Logger::info( 'Skipping missing product', [ 'product_id' => $product_id ] );
                    return;
                }

                $callback( $product );
            }
        );
    }
}
